<?php
/*======================================================================*\
|| #################################################################### ||
|| # Message Popup v 1.0 by 7beebi.com                                # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: msgpopup.php,v $ - $Revision: 1.0 $');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
        print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
// Disable done popup
$msgpopupsdone = $db->query_read("
            SELECT id, active
            FROM " . TABLE_PREFIX . "msgpopup
            WHERE active = 1
");

while ($msgpopupdone = $db->fetch_array($msgpopupsdone))
{
             $popupdone = $db->query_first("
             SELECT msgid, done
             FROM " . TABLE_PREFIX . "msgpopupuser
             WHERE msgid = " . $msgpopupdone['id'] . "
             AND done = 0
             ");

             if (!$popupdone)
             {
                  $db->query_write("UPDATE " . TABLE_PREFIX . "msgpopup SET active = 0 WHERE id = " . $msgpopupdone['id'] . "");
             }
}
// end Disable

print_cp_header($vbphrase['msgpopup']);

if (empty($_REQUEST['do']))
{

        $msgpopups = $db->query_read("
        SELECT *
        FROM " . TABLE_PREFIX . "msgpopup
        ORDER BY id ASC
        ");

        print_form_header('msgpopup', 'add', $vbphrase['msgpopup']);
        print_table_header($vbphrase['add_msgpopup']);
        print_textarea_row("<b>" . $vbphrase['text'] . "</b>", 'msg', '', 8, 60);
        print_membergroup_row("<b>" . $vbphrase['usergroups'] . "</b>", 'usergroup', 2, NULL);
        print_input_row("<b>" . $vbphrase['user'] . "</b>", 'user', '');
        print_input_row("<b>" . $vbphrase['refarelink'] . "</b>", 'refarelink', '');
        print_input_row("<b>" . $vbphrase['timeout'] . "</b>", 'timeout', 0);
        print_yes_no_row("<b>" . $vbphrase['msgpopup_active'] . "</b>", 'active', '1');
        print_submit_row($vbphrase['save'], false);
        print_table_footer();

        print_form_header("msgpopup");
        print_table_header($vbphrase['msgpopup'],8);
                $header = array();
                $header[] = $vbphrase['text'];
                $header[] = $vbphrase['usergroup'];
                $header[] = $vbphrase['user'];
                $header[] = $vbphrase['refarelink'];
                $header[] = $vbphrase['state'];
                $header[] = $vbphrase['time'];
                $header[] = $vbphrase['timeout'];
                $header[] = '';
                print_cells_row($header, 1, 0, 1);
                $cell = array();
                while ($msgpopup = $db->fetch_array($msgpopups))
                {
                        $cell[] = $msgpopup['msg'];
                        $cell[] = $msgpopup['usergroup'];
                        $cell[] = $msgpopup['user'];
                        $cell[] = $msgpopup['refarelink'];
                        $cell[] = iif($msgpopup['active'] != 0,$vbphrase['msgpopup_active'],$vbphrase['msgpopup_disable']);
                        $cell[] = vbdate($vbulletin->options['dateformat'], $msgpopup['dateline'], 1)."  ".vbdate($vbulletin->options['timeformat'], $msgpopup['dateline']);
                        $cell[] = $msgpopup['timeout'] . "  / ";
                        $cell[] = iif($msgpopup['id'] == 0 ,'','<a href="msgpopup.php?do=delete&id=' . $msgpopup['id'] . '">' . $vbphrase['delete'] . '</a> <a href="msgpopup.php?do=edit&id=' . $msgpopup['id'] . '">' . $vbphrase['edit'] . '</a>');
                        print_cells_row($cell, 0, 0, 1, 1, 0, 1);
                        unset($cell);
                        $cell = array();
                }
        print_table_footer();
}

elseif ($_REQUEST['do'] == 'edit')
{
        $vbulletin->input->clean_array_gpc('r', array
        (
                'id'  => TYPE_INT,
        ));

        $msgpopup = $db->query_first("SELECT *
        FROM " . TABLE_PREFIX . "msgpopup
        WHERE id = " . $vbulletin->GPC['id'] . "
        ");

        $usergroup['membergroupids'] = $msgpopup['usergroup'];

        print_form_header('msgpopup', 'update',$vbphrase['msgpopup']);
        print_table_header($vbphrase['edit_msgpopup']);
        print_textarea_row("<b>" . $vbphrase['text'] . "</b>",'msg',$msgpopup['msg'], 8, 60);
        print_membergroup_row("<b>" . $vbphrase['usergroups'] . "</b>", 'usergroup', 2, $usergroup);
        print_input_row("<b>" . $vbphrase['user'] . "</b>", 'user', $msgpopup['user']);
        print_input_row("<b>" . $vbphrase['refarelink'] . "</b>", 'refarelink', $msgpopup['refarelink']);
        print_input_row("<b>" . $vbphrase['timeout'] . "</b>",'timeout',$msgpopup['timeout']);
        print_yes_no_row("<b>" . $vbphrase['msgpopup_active'] . "</b>", 'active', $msgpopup['active']);
        construct_hidden_code('id', $msgpopup['id']);
        print_submit_row($vbphrase['save'],false);
        print_table_footer();

}

elseif ($_REQUEST['do'] == 'update' OR $_REQUEST['do'] == 'add')
{
        $vbulletin->input->clean_array_gpc('r', array
        (
                'id'           => TYPE_INT,
                'msg'          => TYPE_STR,
                'usergroup'    => TYPE_ARRAY_INT,
                'user'         => TYPE_STR,
                'refarelink'   => TYPE_STR,
                'active'       => TYPE_INT,
                'timeout'      => TYPE_INT,

        ));

        if (empty($vbulletin->GPC['msg']))
        {
                print_cp_message($vbphrase['write_msg'], 'msgpopup.php');
        }
        elseif (empty($vbulletin->GPC['usergroup']) AND empty($vbulletin->GPC['user']))
        {
                print_cp_message($vbphrase['select_group_users'], 'msgpopup.php', 3);
        }
        else
        {
                $groupsid = '';

                if (!empty($vbulletin->GPC['usergroup']))
                {
                   foreach($vbulletin->GPC['usergroup'] as $group)
                   {
                      if ($groupsid == "")
                      {
                          $groupsid = $group;
                      }

                      else
                      {
                          $groupsid .= ",$group";
                      }

                   }
                }

                if ($vbulletin->GPC['id'] == 0)
                {
                     $db->query_write("
                        INSERT INTO " . TABLE_PREFIX . "msgpopup
                                (msg, usergroup, user, refarelink, active, dateline, timeout)
                        VALUES
                                ('" . $vbulletin->GPC['msg'] . "', '" . $groupsid . "', '" . $vbulletin->GPC['user'] . "', '" . $vbulletin->GPC['refarelink'] . "', '" . $vbulletin->GPC['active'] . "', '" . TIMENOW . "', '" . $vbulletin->GPC['timeout'] . "')"
                     );

                     $msgpopups = $db->query_read("
                                  SELECT id
                                  FROM " . TABLE_PREFIX . "msgpopup
                                  ");

                     while ($msgpopup = $db->fetch_array($msgpopups))
                     {
                         $msgid = $msgpopup['id'];
                     }
                }
                else
                {
                    $db->query_write("UPDATE " . TABLE_PREFIX . "msgpopup
                        SET  msg = '" . $vbulletin->GPC['msg'] . "', usergroup = '$groupsid', user = '" . $vbulletin->GPC['user'] . "', refarelink = '" . $vbulletin->GPC['refarelink'] . "', active = " . $vbulletin->GPC['active'] . ", dateline = '" . TIMENOW . "', timeout = '" . $vbulletin->GPC['timeout'] . "'
                        WHERE id = " . $vbulletin->GPC['id'] . "
                        ");

                    $db->query_write("DELETE FROM " . TABLE_PREFIX . "msgpopupuser WHERE msgid = " . $vbulletin->GPC['id'] . "");
                }

                if (!empty($vbulletin->GPC['usergroup']) AND empty($vbulletin->GPC['user']))
                {
                    $users = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE usergroupid IN (" . $groupsid . ")
                    ORDER BY userid DESC
                    ");
                }
                elseif (empty($vbulletin->GPC['usergroup']) AND !empty($vbulletin->GPC['user']))
                {
                    $users = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE userid IN (" . $vbulletin->GPC['user'] . ")
                    ORDER BY userid DESC
                    ");
                }
                elseif (!empty($vbulletin->GPC['usergroup']) AND !empty($vbulletin->GPC['user']))
                {
                    $usersg = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE usergroupid IN (" . $groupsid . ")
                    ORDER BY userid DESC
                    ");

                    $usersu = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE usergroupid NOT IN (" . $groupsid . ")
                    AND userid IN (" . $vbulletin->GPC['user'] . ")
                    ORDER BY userid DESC
                    ");
                }

                if (!empty($vbulletin->GPC['usergroup']) AND !empty($vbulletin->GPC['user']))
                {

                   while ($user = $db->fetch_array($usersg))
                   {
                                      $db->query_write("
                                      INSERT INTO " . TABLE_PREFIX . "msgpopupuser
                                             (userid, msgid)
                                      VALUES
                                            (" . $user['userid'] . ", " . iif($vbulletin->GPC['id'] == 0, $msgid, $vbulletin->GPC['id']). ")
                                      ");
                   }

                   while ($user = $db->fetch_array($usersu))
                   {
                                      $db->query_write("
                                      INSERT INTO " . TABLE_PREFIX . "msgpopupuser
                                             (userid, msgid)
                                      VALUES
                                            (" . $user['userid'] . ", " . iif($vbulletin->GPC['id'] == 0, $msgid, $vbulletin->GPC['id']). ")
                                      ");
                   }
                }
                else
                {
                   while ($user = $db->fetch_array($users))
                   {
                                      $db->query_write("
                                      INSERT INTO " . TABLE_PREFIX . "msgpopupuser
                                             (userid, msgid)
                                      VALUES
                                            (" . $user['userid'] . ", " . iif($vbulletin->GPC['id'] == 0, $msgid, $vbulletin->GPC['id']). ")
                                      ");
                   }
                }

                iif($vbulletin->GPC['id'] == 0, print_cp_message($vbphrase['msgbeenadded'], 'msgpopup.php'), print_cp_message($vbphrase['msgupdated'], 'msgpopup.php'));

        }
}

elseif ($_REQUEST['do'] == 'delete')
{
        $vbulletin->input->clean_array_gpc('r', array
        (
                'id'  => TYPE_INT,
        ));

        $db->query_write("DELETE FROM " . TABLE_PREFIX . "msgpopup WHERE id = " . $vbulletin->GPC['id'] . "");

        $db->query_write("DELETE FROM " . TABLE_PREFIX . "msgpopupuser WHERE msgid = " . $vbulletin->GPC['id'] . "");

        print_cp_message($vbphrase['msgdeleted'], 'msgpopup.php');
}

elseif ($_REQUEST['do'] == 'statistics')
{
        $msgpopups = $db->query_read("
        SELECT *
        FROM " . TABLE_PREFIX . "msgpopup
        ORDER BY id ASC"
        );

        print_form_header();
        print_table_header($vbphrase['statistics'],5);
                $header = array();
                $header[] = $vbphrase['text'];
                $header[] = $vbphrase['unread'];
                $header[] = $vbphrase['read'];
                $header[] = $vbphrase['ignore'];
                $header[] = '';
                print_cells_row($header, 1, 0, 1);
                $cell = array();
                while ($msgpopup = $db->fetch_array($msgpopups))
                {
                        $unread = $db->query_first("
                        SELECT COUNT(*) AS a
                        FROM " . TABLE_PREFIX . "msgpopupuser
                        WHERE msgid = " . $msgpopup['id'] . "
                        AND done = 0
                        ");

                        $read = $db->query_first("
                        SELECT COUNT(*) AS b
                        FROM " . TABLE_PREFIX . "msgpopupuser
                        WHERE msgid = " . $msgpopup['id'] . "
                        AND done = 1
                        ");

                        $ignore = $db->query_first("
                        SELECT COUNT(*) AS c
                        FROM " . TABLE_PREFIX . "msgpopupuser
                        WHERE msgid = " . $msgpopup['id'] . "
                        AND done = 2
                        ");

                        $cell[] = $msgpopup['msg'];
                        $cell[] = "<a href=msgpopup.php?do=list&id=" . $msgpopup['id'] . "&type=0>" . $unread['a'] . "</a>";
                        $cell[] = "<a href=msgpopup.php?do=list&id=" . $msgpopup['id'] . "&type=1>" . $read['b'] . "</a>";
                        $cell[] = "<a href=msgpopup.php?do=list&id=" . $msgpopup['id'] . "&type=2>" . $ignore['c'] . "</a>";
                        $cell[] = '<a href="msgpopup.php?do=refresh&id=' . $msgpopup['id'] . '">' . $vbphrase['rebuild'] . '</a>';
                        print_cells_row($cell, 0, 0, 1, 1, 0, 1);
                        unset($cell);
                        $cell = array();
                }
        print_table_footer();
}

elseif ($_REQUEST['do'] == 'refresh')
{
        $vbulletin->input->clean_array_gpc('r', array
        (
                'id'  => TYPE_INT,
        ));

        $msgpopup = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "msgpopup WHERE id = " . $vbulletin->GPC['id'] . "");
        
        if (empty($msgpopup['usergroup']) AND empty($msgpopup['user']))
        {
                print_cp_message(' ', 'msgpopup.php', 3);
        }

        $db->query_write("UPDATE " . TABLE_PREFIX . "msgpopup SET  active = 1, dateline = '" . TIMENOW . "' WHERE id = " . $vbulletin->GPC['id'] . "");

        $db->query_write("DELETE FROM " . TABLE_PREFIX . "msgpopupuser WHERE msgid = " . $vbulletin->GPC['id'] . "");

        if (!empty($msgpopup['usergroup']) AND empty($msgpopup['user']))
        {
                    $users = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE usergroupid IN (" . $msgpopup['usergroup'] . ")
                    ORDER BY userid DESC
                    ");
        }
        elseif (empty($msgpopup['usergroup']) AND !empty($msgpopup['user']))
        {
                    $users = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE userid IN (" . $msgpopup['user'] . ")
                    ORDER BY userid DESC
                    ");
        }
        elseif (!empty($msgpopup['usergroup']) AND !empty($msgpopup['user']))
        {
                    $usersg = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE usergroupid IN (" . $msgpopup['usergroup'] . ")
                    ORDER BY userid DESC
                    ");

                    $usersu = $db->query_read("
                    SELECT userid
                    FROM " . TABLE_PREFIX . "user
                    WHERE usergroupid NOT IN (" . $msgpopup['usergroup'] . ")
                    AND userid IN (" . $msgpopup['user'] . ")
                    ORDER BY userid DESC
                    ");
        }

        if (!empty($msgpopup['usergroup']) AND !empty($msgpopup['user']))
        {

                   while ($user = $db->fetch_array($usersg))
                   {
                                      $db->query_write("
                                      INSERT INTO " . TABLE_PREFIX . "msgpopupuser
                                             (userid, msgid)
                                      VALUES
                                            (" . $user['userid'] . ", " . $vbulletin->GPC['id'] . ")
                                      ");
                   }

                   while ($user = $db->fetch_array($usersu))
                   {
                                      $db->query_write("
                                      INSERT INTO " . TABLE_PREFIX . "msgpopupuser
                                             (userid, msgid)
                                      VALUES
                                            (" . $user['userid'] . ", " . $vbulletin->GPC['id'] . ")
                                      ");
                   }
       }
       else
       {
                   while ($user = $db->fetch_array($users))
                   {
                                      $db->query_write("
                                      INSERT INTO " . TABLE_PREFIX . "msgpopupuser
                                             (userid, msgid)
                                      VALUES
                                            (" . $user['userid'] . ", " . $vbulletin->GPC['id'] . ")
                                      ");
                   }
       }

       print_cp_message($vbphrase['msgupdated'], 'msgpopup.php?do=statistics');
}

elseif ($_REQUEST['do'] == 'list')
{
        $vbulletin->input->clean_array_gpc('r', array
        (
                'id'           => TYPE_INT,
                'type'         => TYPE_INT,
                'limitstart'   => TYPE_INT,
                'limitnumber'  => TYPE_INT,
        ));

        if (empty($vbulletin->GPC['limitstart']))
        {
             $vbulletin->GPC['limitstart'] = 0;
        }
        else
        {
             $vbulletin->GPC['limitstart']--;
        }

        if (empty($vbulletin->GPC['limitnumber']) OR $vbulletin->GPC['limitnumber'] == 0)
        {
            $vbulletin->GPC['limitnumber'] = 30;
        }

        $countusers = $db->query_first("SELECT COUNT(*) AS users FROM " . TABLE_PREFIX . "msgpopupuser AS msgpopupuser WHERE msgid = " . $vbulletin->GPC['id'] . " AND done = " . $vbulletin->GPC['type'] . "");
        $limitfinish = $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'];

        $msgpopups = $db->query_read("
        SELECT *
        FROM " . TABLE_PREFIX . "msgpopupuser
        WHERE msgid = " . $vbulletin->GPC['id'] . "
        AND done = " . $vbulletin->GPC['type'] . "
        ORDER BY id DESC
        LIMIT " . $vbulletin->GPC['limitstart'] . ", " . $vbulletin->GPC['limitnumber'] ."
        ");

        print_form_header('msgpopup','list');
        print_table_header($vbphrase['statistics'], iif($vbulletin->GPC['type'] != 1,3,2));

                $header = array();
                $header[] = $vbphrase['user'];
                $header[] = $vbphrase['state'];
                if($vbulletin->GPC['type'] != 1)
                $header[] = '';

                print_cells_row($header, 1, 0, 1);

                $cell = array();

                while ($msgpopup = $db->fetch_array($msgpopups))
                {
                        $user = $db->query_first("
                        SELECT userid, username
                        FROM " . TABLE_PREFIX . "user
                        WHERE userid = " . $msgpopup['userid'] . "
                        ");

                        $cell[] = "<a href=user.php?do=edit&u=" . $user['userid'] . " target=_blank>" . $user['username'] . "</a>";
                        if ($vbulletin->GPC['type'] == 0)
                        {
                            $cell[] = $vbphrase['unread'];
                            $cell[] = "<a href=msgpopup.php?do=changestate&id=" . $msgpopup['id'] . "&type=" . $vbulletin->GPC['type'] . ">  </a>";
                        }
                        elseif ($vbulletin->GPC['type'] == 1)
                        {
                            $cell[] = vbdate($vbulletin->options['dateformat'], $msgpopup['dateline'], 1)."  ".vbdate($vbulletin->options['timeformat'], $msgpopup['dateline']);
                        }
                        elseif ($vbulletin->GPC['type'] == 2)
                        {
                            $cell[] = $vbphrase['ignore'];
                            $cell[] = "<a href=msgpopup.php?do=changestate&id=" . $msgpopup['id'] . "&type=" . $vbulletin->GPC['type'] . "> </a>";
                        }
                        print_cells_row($cell, 0, 0, 1, 1, 0, 1);
                        unset($cell);
                        $cell = array();
                }

        construct_hidden_code('id', $vbulletin->GPC['id']);
        construct_hidden_code('type', $vbulletin->GPC['type']);
        construct_hidden_code('limitnumber', $vbulletin->GPC['limitnumber']);

        if ($vbulletin->GPC['limitstart'] == 0 AND $countusers['users'] > $vbulletin->GPC['limitnumber'])
        {
            construct_hidden_code('limitstart', $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'] + 1);
            print_submit_row($vbphrase['next_page'], 0, $colspan);
        }
        else if ($limitfinish < $countusers['users'])
        {
            construct_hidden_code('limitstart', $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'] + 1);
            print_submit_row($vbphrase['next_page'], 0, $colspan, $vbphrase['prev_page'], '', true);
        }
        else if ($limitfinish >= $countusers['users'])
        {
            print_submit_row($vbphrase['first_page'], 0, $colspan, $vbphrase['prev_page'], '', true);
        }

        print_table_footer();
}

elseif ($_REQUEST['do'] == 'changestate')
{
        $vbulletin->input->clean_array_gpc('r', array
        (
                'id'   => TYPE_INT,
                'type' => TYPE_INT,
        ));

        $db->query_write("UPDATE " . TABLE_PREFIX . "msgpopupuser SET done = " . iif($vbulletin->GPC['type'] == 0,2,0) . " WHERE id = " . $vbulletin->GPC['id'] . "");

        print_cp_message($vbphrase['msgupdated'], 'msgpopup.php?do=statistics');
}

print_cp_footer();

?>
